using UnityEngine;

public class Autopilot : MonoBehaviour
{
    public Transform sphereCenter; // Reference to the sphere's center transform
    public float orbitSpeed = 10f; // Speed of the orbit

    private bool isAutopilotEnabled = false; // Flag to track autopilot mode
    private Vector3 orbitAxis; // Fixed axis for rotation

    // Add a public property to access the autopilot mode status
    public bool IsAutopilotEnabled => isAutopilotEnabled;

    private void Start()
    {
        // Set the orbit axis as the dot's forward vector
        orbitAxis = transform.forward;
    }

    private void Update()
    {
        // Check if the "R" key is pressed
        if (Input.GetKeyDown(KeyCode.R))
        {
            ToggleAutopilot(); // Toggle autopilot mode
        }

        // Check if autopilot mode is enabled
        if (isAutopilotEnabled)
        {
            // Calculate the rotation angle for the orbit
            float rotationAngle = orbitSpeed * Time.deltaTime;

            // Rotate the dot around the sphere center
            transform.RotateAround(sphereCenter.position, orbitAxis, rotationAngle);
        }
    }

    private void ToggleAutopilot()
    {
        isAutopilotEnabled = !isAutopilotEnabled; // Toggle autopilot mode
    }
}
