using UnityEngine;

public class CameraFollow : MonoBehaviour
{
    public Transform target; // Reference to the dot's transform
    public float zoomSpeed = 5f; // Speed of the zoom effect
    public float minZoom = 1f; // Minimum field of view
    public float maxZoom = 50f; // Maximum field of view

    private Camera mainCamera;
    private Vector3 initialOffset;
    private bool isMoving;

    private void Start()
    {
        mainCamera = Camera.main;
        initialOffset = transform.position - target.position;
    }

    private void LateUpdate()
    {
        float horizontalInput = Input.GetAxis("Horizontal");
        float verticalInput = Input.GetAxis("Vertical");
        isMoving = horizontalInput != 0f || verticalInput != 0f;

        // Check if the dot is moving
        if (isMoving)
        {
            // Calculate the target position and zoom based on dot's speed
            Vector3 targetPosition = target.position + initialOffset;
            float dotSpeed = target.GetComponent<DotMovement>().speed;
            float targetFieldOfView = Mathf.Lerp(maxZoom, minZoom, dotSpeed);

            // Update camera position and field of view
            transform.position = Vector3.Lerp(transform.position, targetPosition, Time.deltaTime * zoomSpeed);
            mainCamera.fieldOfView = Mathf.Lerp(mainCamera.fieldOfView, targetFieldOfView, Time.deltaTime * zoomSpeed);
        }
        else
        {
            // Zoom out to default values when the dot stops moving
            transform.position = Vector3.Lerp(transform.position, target.position + initialOffset, Time.deltaTime * zoomSpeed);
            mainCamera.fieldOfView = Mathf.Lerp(mainCamera.fieldOfView, maxZoom, Time.deltaTime * zoomSpeed);
        }
    }
}
