using UnityEngine;

public class CameraRotation : MonoBehaviour
{
    public Transform target; // Reference to the dot's transform
    public float rotationSpeed = 5f; // Speed of the rotation effect

    private Vector3 offset;

    private void Start()
    {
        offset = transform.position - target.position;
    }

    private void Update()
    {
        float rotationInput = Input.GetAxis("Tilt");
        float rotationAmount = rotationInput * rotationSpeed * Time.deltaTime;

        // Rotate the camera around the target
        transform.RotateAround(target.position, Vector3.up, rotationAmount);

        // Calculate the new position of the camera after rotation
        Vector3 desiredPosition = target.position + offset;
        Quaternion desiredRotation = Quaternion.LookRotation(target.position - transform.position, Vector3.up);

        // Smoothly move and rotate the camera towards the desired position and rotation
        transform.position = Vector3.Lerp(transform.position, desiredPosition, rotationSpeed * Time.deltaTime);
        transform.rotation = Quaternion.Slerp(transform.rotation, desiredRotation, rotationSpeed * Time.deltaTime);
    }
}
