using UnityEngine;

public class CameraTilt : MonoBehaviour
{
    public Transform sphere; // Reference to the sphere's transform
    public float rotationSpeed = 50f; // Adjust the rotation speed as needed

    private Vector3 offset; // Offset between camera and sphere

    private void Start()
    {
        // Calculate the initial offset between camera and sphere
        offset = transform.position - sphere.position;
    }

    private void Update()
    {
        // Check for input to rotate the camera
        float rotationInput = Input.GetAxis("Tilt");

        // Calculate the desired rotation
        Quaternion desiredRotation = Quaternion.Euler(rotationInput * rotationSpeed * Time.deltaTime, 0f, 0f);
        Quaternion currentRotation = transform.rotation;

        // Interpolate between the current rotation and the desired rotation
        Quaternion newRotation = Quaternion.Slerp(currentRotation, desiredRotation, Time.deltaTime * rotationSpeed);

        // Set the camera's position and rotation
        transform.position = sphere.position + offset;
        transform.rotation = newRotation;
    }
}
