using UnityEngine;
using UnityEngine.UI;
using TMPro;

public class DistanceTextUpdater : MonoBehaviour
{
    public TextMeshProUGUI distanceText; // Reference to the UI TextMeshProUGUI component
    public Transform dotTransform; // Reference to the dot's transform
    public Transform sphereCenter; // Reference to the sphere's center transform
    public float radius; // The radius of the sphere

    private void Update()
    {
        Vector3 dotToCenter = dotTransform.position - sphereCenter.position;
        float distanceToCenter = dotToCenter.magnitude;

        if (distanceToCenter > radius)
        {
            Vector3 newDotPosition = sphereCenter.position + dotToCenter.normalized * radius;
            dotTransform.position = newDotPosition; // Wrap the dot around the surface of the sphere
        }

        float distanceToSurface = radius - distanceToCenter;
        float distanceInMiles = Mathf.Ceil(((distanceToSurface) * 7917.5f) - 3959f); // Subtract 3959 from distanceToSurface and calculate the distance in miles from the dot to the surface

        distanceText.SetText("Surface: " + distanceInMiles.ToString("0") + " miles");
    }
}
