using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class DotBillboard : MonoBehaviour
{
    private GameObject dot;
    private Camera mainCamera;

    private void Start()
    {
        dot = transform.parent.gameObject;
        mainCamera = Camera.main; // Get reference to the main camera
    }

    private void LateUpdate()
    {
        if (mainCamera != null) // Check if the main camera reference is valid
        {
            // Face the camera
            transform.LookAt(mainCamera.transform.position);
            transform.rotation = Quaternion.Euler(0f, transform.rotation.eulerAngles.y, 0f);
        }

        // Follow the dot's position
        transform.position = dot.transform.position;
    }
}
