using UnityEngine;

public class DotController : MonoBehaviour
{
    public float speed = 2f; // Adjust the speed value to control the dot's movement speed

    private void Update()
    {
        float horizontalInput = Input.GetAxis("Horizontal");
        float verticalInput = Input.GetAxis("Vertical");

        Vector3 movement = new Vector3(horizontalInput, verticalInput, 0f);
        movement = movement.normalized * speed * Time.deltaTime * 0.1f; // Adjust the multiplication factor to control the dot's speed

        transform.position += movement; // Move the dot

        // Rotate the capsule to face the movement direction
        if (movement != Vector3.zero)
        {
            Quaternion targetRotation = Quaternion.LookRotation(movement, Vector3.up);
            // Rotate the capsule object here
        }
    }
}
