using System.Collections.Generic;
using UnityEngine;

public class DotTrail : MonoBehaviour
{
    public GameObject trailPrefab; // Reference to the trail prefab
    public float trailSpacing = 0.01f; // Spacing between trail segments
    public int maxTrailSegments = 999999; // Maximum number of trail segments
    public Transform target; // Reference to the target's transform
    public Transform trailParent; // Reference to the trail parent object

    private List<GameObject> trailSegments; // List to store the trail segments

    private void Start()
    {
        trailSegments = new List<GameObject>(); // Initialize the trail segments list
    }

    private void Update()
    {
        // Check if the dot has moved a sufficient distance to create a new trail segment
        if (trailSegments.Count == 0 || Vector3.Distance(transform.position, trailSegments[trailSegments.Count - 1].transform.position) >= trailSpacing)
        {
            CreateTrailSegment(); // Create a new trail segment
        }

        // Rotate the trail parent object to match the target's rotation
        trailParent.rotation = target.rotation;
    }

    private void CreateTrailSegment()
    {
        // Instantiate a new trail segment prefab and parent it to the trail parent object
        GameObject trailSegment = Instantiate(trailPrefab, transform.position, target.rotation);
        trailSegment.transform.SetParent(trailParent);
        trailSegments.Add(trailSegment); // Add the trail segment to the list

        // Remove excess trail segments if the maximum limit is reached
        if (trailSegments.Count > maxTrailSegments)
        {
            GameObject oldestSegment = trailSegments[0];
            trailSegments.RemoveAt(0);
            Destroy(oldestSegment); // Destroy the oldest trail segment
        }
    }
}
