using UnityEngine;

public class MaterialToggle : MonoBehaviour
{
    public Material material1; // Reference to the first material
    public Material material2; // Reference to the second material

    private Renderer sphereRenderer; // Reference to the sphere's renderer
    private bool isMaterial1Active = true; // Flag to track the active material

    private void Start()
    {
        sphereRenderer = GetComponent<Renderer>(); // Get the sphere's renderer component
        SetActiveMaterial(); // Set the initial active material
    }

    private void Update()
    {
        // Check for a key press to toggle materials
        if (Input.GetKeyDown(KeyCode.T))
        {
            ToggleMaterial(); // Toggle between the two materials
        }
    }

    private void ToggleMaterial()
    {
        isMaterial1Active = !isMaterial1Active; // Toggle the active material flag
        SetActiveMaterial(); // Set the new active material
    }

    private void SetActiveMaterial()
    {
        Material activeMaterial = isMaterial1Active ? material1 : material2; // Determine the active material

        // Apply the active material to the sphere's renderer
        sphereRenderer.material = activeMaterial;
    }
}
