using UnityEngine;

public class ToggleRotation : MonoBehaviour
{
    public KeyCode toggleRotationKey = KeyCode.Space; // Key to toggle rotation, mappable in the Inspector
    public Transform sphereTransform; // Reference to the sphere's transform
    public float rotationSpeed = 20f; // Adjust the rotation speed as needed

    private bool isRotationEnabled = true; // Flag to track the rotation state

    private void Update()
    {
        if (Input.GetKeyDown(toggleRotationKey))
        {
            isRotationEnabled = !isRotationEnabled; // Toggle the rotation state
        }

        if (isRotationEnabled)
        {
            // Rotate the sphere continuously
            sphereTransform.Rotate(Vector3.up, rotationSpeed * Time.deltaTime);
        }
    }
}
