using UnityEngine;
using UnityEngine.Video;

public class VideoController : MonoBehaviour
{
    public VideoPlayer videoPlayer; // Reference to the VideoPlayer component
    public DotMovement dotMovement; // Reference to the DotMovement component
    public Autopilot autopilot; // Reference to the Autopilot component

    private bool isPlaying = false; // Flag to track if the video is currently playing

    private void Update()
    {
        // Check if the dot is moving or autopilot mode is enabled
        bool shouldPlay = dotMovement.IsMoving || (autopilot != null && autopilot.IsAutopilotEnabled);

        // Check if the video should play or pause
        if (shouldPlay && !isPlaying)
        {
            videoPlayer.Play();
            isPlaying = true;
        }
        else if (!shouldPlay && isPlaying)
        {
            videoPlayer.Pause();
            isPlaying = false;
        }

        // Check if autopilot mode is enabled
        if (autopilot != null && autopilot.IsAutopilotEnabled)
        {
            // Enable audio playback while autopilot is active
            videoPlayer.audioOutputMode = VideoAudioOutputMode.AudioSource;
        }
        else
        {
            // Disable audio playback when autopilot is not active
            videoPlayer.audioOutputMode = VideoAudioOutputMode.None;
        }
    }
}
